import React, { Component } from 'react';
import { View, Button } from 'react-native';
import ChildComponent from './ChildComponent';
class ParentComponent extends Component {
    constructor(props) {
        super(props);
        this.state = {
            language: 'Java',
        };
        console.log('ParentComponent: Constructor called.');
    }
    componentDidMount() {
        console.log('ParentComponent: componentDidMount called.');
    }
    componentDidUpdate(prevProp, prevState) {
        console.log('ParentComponent: componentDidUpdate called.');
    }
    componentWillUnmount() {
        console.log('ParentComponent: componentWillUnmount called.');
    }
    render() {
        console.log('ParentComponent: render called.');
        const handleClick = () => {
            console.log('ParentComponent: handleClick called.');
            let { language } = this.state;
            language = language == 'Java' ? 'C' : 'Java';
            this.setState({ language: language });
        };
        const { language } = this.state;
        return (
            <View style={{ flex: 1, justifyContent: 'center' }}>
                <ChildComponent name={language} />
                <Button onPress={() => handleClick()} title="Change" />
            </View>
        );
    }
}
export default ParentComponent;
